package it.eng.eremita.graphql.types;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import graphql.servlet.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.annotations.Metadata;
import it.eng.eremita.graphql.types.other.EremitaException;
import it.eng.eremita.graphql.types.other.EremitaSecurityException;
import it.eng.eremita.graphql.types.other.Pagination;
import it.eng.eremita.jpa.entity.DatiBinari;
import it.eng.eremita.jpa.entity.Documento;
import it.eng.eremita.jpa.entity.Intervento;
import it.eng.eremita.jpa.entity.Metadato;
import it.eng.eremita.jpa.entity.MetadatoHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioSpecie;
import it.eng.eremita.jpa.entity.Segnalazione;
import it.eng.eremita.jpa.entity.SegnalazioneAltreSpecie;
import it.eng.eremita.jpa.entity.Utente;
import it.eng.eremita.jpa.entity.ValoreMetadato;
import it.eng.eremita.jpa.manager.Accessor;
import it.eng.eremita.jpa.manager.CoenagrionMH;
import it.eng.eremita.jpa.manager.DBImporter;
import it.eng.eremita.jpa.manager.EremitaManager;
import it.eng.eremita.jpa.manager.Graphoderus1;
import it.eng.eremita.jpa.manager.GraphoderusMH;
import it.eng.eremita.jpa.manager.Osmoderma1;
import it.eng.eremita.jpa.manager.Osmoderma2;
import it.eng.eremita.jpa.manager.Osmoderma3;
import it.eng.eremita.jpa.manager.Osmoderma4;
import it.eng.eremita.jpa.manager.Osmoderma5;
import it.eng.eremita.jpa.manager.Osmoderma6;
import it.eng.eremita.jpa.manager.Osmoderma7;
import it.eng.eremita.jpa.manager.OsmodermaMH;
import it.eng.eremita.jpa.manager.OsmodermaMH2;
import it.eng.eremita.jpa.manager.OsmodermaMH3;
import it.eng.eremita.jpa.manager.OsmodermaMH4;
import it.eng.eremita.jpa.manager.OsmodermaMH5;
import it.eng.eremita.jpa.manager.OsmodermaMH6;
import it.eng.eremita.jpa.manager.OsmodermaMH7;
import it.eng.eremita.jpa.manager.OsmodermaMH8;
import it.eng.eremita.jpa.manager.OsmodermaMH9;
import it.eng.eremita.jpa.manager.Rosalia1;
import it.eng.eremita.jpa.manager.Rosalia10;
import it.eng.eremita.jpa.manager.Rosalia2;
import it.eng.eremita.jpa.manager.Rosalia3;
import it.eng.eremita.jpa.manager.Rosalia4;
import it.eng.eremita.jpa.manager.Rosalia5;
import it.eng.eremita.jpa.manager.Rosalia6;
import it.eng.eremita.jpa.manager.Rosalia7;
import it.eng.eremita.jpa.manager.Rosalia8;
import it.eng.eremita.jpa.manager.Rosalia9;
import it.eng.eremita.jpa.manager.RosaliaMH;
import it.eng.eremita.jpa.manager.RosaliaMH2;
import it.eng.eremita.jpa.manager.RosaliaMH3;
import it.eng.eremita.jpa.manager.RosaliaMH4;
import it.eng.eremita.jpa.manager.RosaliaMH5;
import it.eng.eremita.jpa.manager.RosaliaMH6;
import it.eng.eremita.jpa.manager.RosaliaMH7;
import it.eng.eremita.jpa.manager.RosaliaMH8;
import it.eng.eremita.jpa.util.ObjectAuthorizer;
import it.eng.eremita.jpa.util.ObjectAuthorizerFactory;

public class Mutation {
	
	private SessionProvider sessionProvider = null;
	
	
	public Mutation(SessionProvider provider) {
		sessionProvider = provider;
	}
	/*
	 * MONITORAGGIO SPECIE
	 */
	@GraphQLMutation(name="updateDocumento")
	public Documento updateDocumento(@GraphQLArgument(name="documento") Documento m) throws EremitaException {
		
		if (m==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), m)) throw new EremitaSecurityException();
		
		aggiornaTracciamento(m);
		
		if (m.getId()==null) {
			m.setUuid(UUID.randomUUID().toString());
		}
		
		
		m = (Documento) Accessor.getEremitaManager().updateAndCommit(m);
		
		
		
		
		return m;
	}

	@GraphQLMutation(name="deleteDocumento")
	public Boolean deleteDocumento(@GraphQLArgument(name="id") Long id) throws EremitaException  {
		
		try {
			Documento d = (Documento)Accessor.getEremitaManager().getById(Documento.class, id);
			if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), d)) throw new EremitaSecurityException();
			if (d!=null && d.getUuid()!=null) {
				Accessor.getEremitaManager().delete(DatiBinari.class, d.getUuid());
			}
			
		} catch (Exception e) {}
		Boolean b = Accessor.getEremitaManager().deleteAndCommit(Documento.class,id);
		
		return b;
	}
	
	/*
	 * METADATI
	 */
	@GraphQLMutation(name="updateMetadatoDocumento")
	public ValoreMetadato updateMetadatoDocumento(@GraphQLArgument(name="documento") Documento m, @GraphQLArgument(name="metadato")String metadato, @GraphQLArgument(name="valore")String valore) {
		return updateMetadatoOggetto(m, metadato, valore);
	}
	
	/*
	 * MONITORAGGIO HABITAT
	 */
	@GraphQLMutation(name="updateMonitoraggioHabitat")
	public MonitoraggioHabitat updateMonitoraggioHabitat(@GraphQLArgument(name="monitoraggioHabitat") MonitoraggioHabitat m) throws EremitaException {
		
		if (m==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), m)) throw new EremitaSecurityException();
		aggiornaTracciamento(m);
		/*if (m.getSegnalaziones()!=null)
			for (Segnalazione s : m.getSegnalaziones()) aggiornaTracciamento(s);
		if (m.getSegnalazioneAltreSpecies()!=null)
			for (SegnalazioneAltreSpecie s : m.getSegnalazioneAltreSpecies()) aggiornaTracciamento(s);*/
		
		if (m.getId()==null) {
			MonitoraggioHabitat m2 = (MonitoraggioHabitat) Accessor.getEremitaManager().updateAndCommit(m);
			m2.setMetadati(m.getMetadati());
			m = m2;
		}
		
		if (m.getMetadati()!=null) {
			for (MetadatoHabitat mm : m.getMetadati()) {
				if (mm.getId()==null) {
					List<MetadatoHabitat> mm2= Accessor.getEremitaManager().getSql(MetadatoHabitat.class, "select * from eremita_metadato_habitat where id_habitat="+
							m.getId()+" and id_metadato='"+mm.getMetadato().getId()+"'");
					if (mm2!=null && mm2.size()>0) {
						mm.setId(mm2.get(0).getId());
					}
				}
				mm.setMonitoraggioHabitat(m);
				updateMetadatoHabitat(mm);
			}
		}
		
		m = (MonitoraggioHabitat) Accessor.getEremitaManager().updateAndCommit(m);
		
		return  Accessor.getEremitaManager().getById(MonitoraggioHabitat.class, m.getId());
	}

	@GraphQLMutation(name="deleteMonitoraggioHabitat")
	public Boolean deleteMonitoraggioHabitat(@GraphQLArgument(name="id") Long id) throws EremitaException {
		MonitoraggioHabitat ms = Accessor.getEremitaManager().getById(MonitoraggioHabitat.class, id);
		if (ms==null) return false;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		return Accessor.getEremitaManager().deleteAndCommit(MonitoraggioHabitat.class,id);
	}
	
	@GraphQLMutation(name="deleteIntervento")
	public Boolean deleteIntervento(@GraphQLArgument(name="id") Long id) throws EremitaException {
		Intervento ms = Accessor.getEremitaManager().getById(Intervento.class, id);
		if (ms==null) return false;
		//if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		return Accessor.getEremitaManager().deleteAndCommit(Intervento.class,id);
	}
	
	@GraphQLMutation(name="updateIntervento")
	public Intervento updateIntervento(@GraphQLArgument(name="intervento") Intervento m) throws EremitaException {
		
		if (m==null) return null;
		
		if (m.getInfo()!=null) {
			
		}
		//if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), m)) throw new EremitaSecurityException();
		aggiornaTracciamento(m);
		/*if (m.getSegnalaziones()!=null)
			for (Segnalazione s : m.getSegnalaziones()) aggiornaTracciamento(s);
		if (m.getSegnalazioneAltreSpecies()!=null)
			for (SegnalazioneAltreSpecie s : m.getSegnalazioneAltreSpecies()) aggiornaTracciamento(s);*/
		
		if (m.getId()==null) {
			Intervento m2 = (Intervento) Accessor.getEremitaManager().updateAndCommit(m);
			m = m2;
		}
		
		
		m = (Intervento) Accessor.getEremitaManager().updateAndCommit(m);
		
		return  Accessor.getEremitaManager().getById(Intervento.class, m.getId());
	}
	
	@GraphQLMutation(name="addMonitoraggioHabitatDocumento")
	public MonitoraggioHabitat addMonitoraggioHabitatDocumento(@GraphQLArgument(name="monitoraggioHabitat") MonitoraggioHabitat m, @GraphQLArgument(name="documento")Documento d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioHabitat ms = (MonitoraggioHabitat) Accessor.getEremitaManager().getById(MonitoraggioHabitat.class, m.getId());
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		Documento d2 = (Documento) Accessor.getEremitaManager().getById(Documento.class, d.getId());
		if (d2==null) return null;
		
		ms.getDocumenti().add(d2);
		
		aggiornaTracciamento(ms);
		aggiornaTracciamento(d2);
		d2.setEntita("monitoraggio_habitat");
		d2.setIdEntita(ms.getId());
		Accessor.getEremitaManager().forceUpdate(d2);
		return (MonitoraggioHabitat) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="addInterventoDocumento")
	public Intervento addInterventoDocumento(@GraphQLArgument(name="intervento") Intervento m, @GraphQLArgument(name="documento")Documento d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		Intervento ms = (Intervento) Accessor.getEremitaManager().getById(Intervento.class, m.getId());
		if (ms==null) return null;
		//if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		Documento d2 = (Documento) Accessor.getEremitaManager().getById(Documento.class, d.getId());
		if (d2==null) return null;
		
		ms.getDocumenti().add(d2);
		
		aggiornaTracciamento(ms);
		aggiornaTracciamento(d2);
		d2.setEntita("eremita_intervento");
		d2.setIdEntita(ms.getId());
		Accessor.getEremitaManager().forceUpdate(d2);
		return (Intervento) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="removeMonitoraggioHabitatDocumento")
	public MonitoraggioHabitat removeMonitoraggioHabitatDocumento(@GraphQLArgument(name="monitoraggioHabitat") MonitoraggioHabitat m, @GraphQLArgument(name="documento")Documento d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioHabitat ms = (MonitoraggioHabitat) Accessor.getEremitaManager().getById(MonitoraggioHabitat.class, m.getId());
		
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		
		Documento d2 = (Documento) Accessor.getEremitaManager().getById(Documento.class, d.getId());
		if (d2==null) return null;
		
		ms.getDocumenti().remove(d2);
		
		aggiornaTracciamento(ms);
		MonitoraggioHabitat mh = Accessor.getEremitaManager().forceUpdateAndCommit(ms);
		Accessor.getEremitaManager().updateSql("delete from eremita_documento where id="+d.getId(),new ArrayList());
		return mh;
	}
	
	@GraphQLMutation(name="removeInterventoDocumento")
	public Intervento removeInterventoDocumento(@GraphQLArgument(name="intervento") Intervento m, @GraphQLArgument(name="documento")Documento d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		Intervento ms = (Intervento) Accessor.getEremitaManager().getById(Intervento.class, m.getId());
		
		if (ms==null) return null;
		//if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		
		Documento d2 = (Documento) Accessor.getEremitaManager().getById(Documento.class, d.getId());
		if (d2==null) return null;
		
		ms.getDocumenti().remove(d2);
		
		
		aggiornaTracciamento(ms);
		Intervento i = (Intervento) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
		
		Accessor.getEremitaManager().updateSql("delete from eremita_documento where id="+d.getId(),new ArrayList());
		
		return i;
	}
	
	@GraphQLMutation(name="addMonitoraggioHabitatMetadato")
	public MonitoraggioHabitat addMonitoraggioHabitatMetadato(@GraphQLArgument(name="monitoraggioHabitat") MonitoraggioHabitat m, @GraphQLArgument(name="metadatoHabitat")MetadatoHabitat d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioHabitat ms = (MonitoraggioHabitat) Accessor.getEremitaManager().getById(MonitoraggioHabitat.class, m.getId());
		
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		MetadatoHabitat d2 = (MetadatoHabitat) Accessor.getEremitaManager().getById(MetadatoHabitat.class, d.getId());
		if (d2==null) return null;
		
		ms.getMetadati().add(d2);
		d2.setMonitoraggioHabitat(ms);
		
		aggiornaTracciamento(ms);
		Accessor.getEremitaManager().forceUpdate(d2);
		return (MonitoraggioHabitat) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="removeMonitoraggioHabitatMetadato")
	public MonitoraggioHabitat removeMonitoraggioSpecieMetadato(@GraphQLArgument(name="monitoraggioHabitat") MonitoraggioHabitat m, @GraphQLArgument(name="metadatoHabitat")MetadatoHabitat d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioHabitat ms = (MonitoraggioHabitat) Accessor.getEremitaManager().getById(MonitoraggioHabitat.class, m.getId());
		
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		
		MetadatoHabitat d2 = (MetadatoHabitat) Accessor.getEremitaManager().getById(MetadatoHabitat.class, d.getId());
		if (d2==null) return null;
		
		ms.getMetadati().remove(d2);
		d2.setMonitoraggioHabitat(null);
		Accessor.getEremitaManager().forceUpdate(d2);
		aggiornaTracciamento(ms);
		return (MonitoraggioHabitat) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="updateMetadatoHabitat")
	public MetadatoHabitat updateMetadatoHabitat(@GraphQLArgument(name="metadatoHabitat") MetadatoHabitat m) throws EremitaException {
		
		if (m==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), m)) throw new EremitaSecurityException();
		/*if (m.getSegnalaziones()!=null)
			for (Segnalazione s : m.getSegnalaziones()) aggiornaTracciamento(s);
		if (m.getSegnalazioneAltreSpecies()!=null)
			for (SegnalazioneAltreSpecie s : m.getSegnalazioneAltreSpecies()) aggiornaTracciamento(s);*/
		
		m = (MetadatoHabitat) Accessor.getEremitaManager().updateAndCommit(m);
		return m;
	}
	
	@GraphQLMutation(name="deleteMetadatoHabitat")
	public Boolean deleteMetadatoHabitat(@GraphQLArgument(name="id") Long id) throws EremitaException {
		MetadatoHabitat ms = Accessor.getEremitaManager().getById(MetadatoHabitat.class, id);
		if (ms==null) return false;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		return Accessor.getEremitaManager().deleteAndCommit(MetadatoHabitat.class,id);
	}

	/*
	 * MONITORAGGIO SPECIE
	 */
	@GraphQLMutation(name="updateMonitoraggioSpecie")
	public MonitoraggioSpecie updateMonitoraggioSpecie(@GraphQLArgument(name="monitoraggioSpecie") MonitoraggioSpecie m) throws EremitaException {
		
		if (m==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), m)) throw new EremitaSecurityException();
		
		if (m.getId()!=null) {
			MonitoraggioSpecie ms = Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
			m.getDocumenti().clear();
			m.getSegnalaziones().clear();
			m.getSegnalazioneAltreSpecies().clear();
			m.getDocumenti().addAll(ms.getDocumenti());
			m.getSegnalaziones().addAll(ms.getSegnalaziones());
			m.getSegnalazioneAltreSpecies().addAll(ms.getSegnalazioneAltreSpecies());
		}
		
		aggiornaTracciamento(m);
		/*if (m.getSegnalaziones()!=null)
			for (Segnalazione s : m.getSegnalaziones()) aggiornaTracciamento(s);
		if (m.getSegnalazioneAltreSpecies()!=null)
			for (SegnalazioneAltreSpecie s : m.getSegnalazioneAltreSpecies()) aggiornaTracciamento(s);*/
		
		m = (MonitoraggioSpecie) Accessor.getEremitaManager().updateAndCommit(m);
		return m;
	}

	@GraphQLMutation(name="deleteMonitoraggioSpecie")
	public Boolean deleteMonitoraggioSpecie(@GraphQLArgument(name="id") Long id) throws EremitaException {
		MonitoraggioSpecie ms = Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, id);
		if (ms==null) return false;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		return Accessor.getEremitaManager().deleteAndCommit(MonitoraggioSpecie.class,id);
	}
	
	@GraphQLMutation(name="addMonitoraggioSpecieDocumento")
	public MonitoraggioSpecie addMonitoraggioSpecieDocumento(@GraphQLArgument(name="monitoraggioSpecie") MonitoraggioSpecie m, @GraphQLArgument(name="documento")Documento d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioSpecie ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		Documento d2 = (Documento) Accessor.getEremitaManager().getById(Documento.class, d.getId());
		if (d2==null) return null;
		
		ms.getDocumenti().add(d2);
		
		aggiornaTracciamento(ms);
		aggiornaTracciamento(d2);
		d2.setEntita("monitoraggio_specie");
		d2.setIdEntita(ms.getId());
		Accessor.getEremitaManager().forceUpdate(d2);
		return (MonitoraggioSpecie) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="removeMonitoraggioSpecieDocumento")
	public MonitoraggioSpecie removeMonitoraggioSpecieDocumento(@GraphQLArgument(name="monitoraggioSpecie") MonitoraggioSpecie m, @GraphQLArgument(name="documento")Documento d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioSpecie ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		

		Accessor.getEremitaManager().updateSql("delete from eremita_monit_specie_doc where documento="+d.getId(), null);
		//ms.getDocumenti().remove(d2);
		ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		aggiornaTracciamento(ms);
		
		MonitoraggioSpecie mm = (MonitoraggioSpecie) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
		Accessor.getEremitaManager().updateSql("delete from eremita_documento where id="+d.getId(),new ArrayList());
		return mm;
	}
	
	@GraphQLMutation(name="addMonitoraggioSpecieSegnalazione")
	public MonitoraggioSpecie addMonitoraggioSpecieSegnalazione(@GraphQLArgument(name="monitoraggioSpecie") MonitoraggioSpecie m, @GraphQLArgument(name="segnalazione")Segnalazione d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioSpecie ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		Segnalazione d2 = (Segnalazione) Accessor.getEremitaManager().getById(Segnalazione.class, d.getId());
		if (d2==null) return null;
		
		ms.getSegnalaziones().add(d2);
		d2.setMonitoraggioSpecie(ms);
		
		aggiornaTracciamento(ms);
		aggiornaTracciamento(d2);
		Accessor.getEremitaManager().forceUpdate(d2);
		return (MonitoraggioSpecie) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="removeMonitoraggioSpecieSegnalazione")
	public MonitoraggioSpecie removeMonitoraggioSpecieSegnalazione(@GraphQLArgument(name="monitoraggioSpecie") MonitoraggioSpecie m, @GraphQLArgument(name="segnalazione")Segnalazione d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		
		
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), m))  throw new EremitaSecurityException();

		
		//Accessor.getEremitaManager().forceUpdateAndCommit(d2);
		//ms.getSegnalaziones().remove(d2);
		Accessor.getEremitaManager().updateSql("delete from eremita_segnalazione where id="+d.getId(), null);

		MonitoraggioSpecie ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		aggiornaTracciamento(ms);
		return (MonitoraggioSpecie) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="addMonitoraggioSpecieSegnalazioneAltreSpecie")
	public MonitoraggioSpecie addMonitoraggioSpecieSegnalazioneAltreSpecie(@GraphQLArgument(name="monitoraggioSpecie") MonitoraggioSpecie m, @GraphQLArgument(name="segnalazioneAltreSpecie")SegnalazioneAltreSpecie d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		MonitoraggioSpecie ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		SegnalazioneAltreSpecie d2 = (SegnalazioneAltreSpecie) Accessor.getEremitaManager().getById(SegnalazioneAltreSpecie.class, d.getId());
		if (d2==null) return null;
		
		//ms.getSegnalazioneAltreSpecies().add(d2);
		d2.setMonitoraggioSpecie(ms);
		
		aggiornaTracciamento(ms);
		aggiornaTracciamento(d2);
		Accessor.getEremitaManager().forceUpdate(d2);
		return (MonitoraggioSpecie) Accessor.getEremitaManager().forceUpdateAndCommit(ms);
	}
	
	@GraphQLMutation(name="removeMonitoraggioSpecieSegnalazioneAltreSpecie")
	public MonitoraggioSpecie removeMonitoraggioSpecieSegnalazioneAltreSpecie(@GraphQLArgument(name="monitoraggioSpecie") MonitoraggioSpecie m, @GraphQLArgument(name="segnalazioneAltreSpecie")SegnalazioneAltreSpecie d) throws EremitaException {
		
		if (m==null || m.getId()==null) return null;
		if (d==null || d.getId()==null) return m;
		//MonitoraggioSpecie ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		
		Accessor.getEremitaManager().updateSql("delete from eremita_segnal_altre_specie where id="+d.getId(), null);

		MonitoraggioSpecie ms = (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, m.getId());
		aggiornaTracciamento(ms);
		return (MonitoraggioSpecie) Accessor.getEremitaManager().forceUpdateAndCommit(ms);

	}
	
	/*
	 * SEGNALAZIONE
	 */
	@GraphQLMutation(name="updateSegnalazione")
	public Segnalazione updateSegnalazione(@GraphQLArgument(name="segnalazione") Segnalazione m) throws EremitaException {
		
		if (m==null) return null;
		//MonitoraggioSpecie ms = Accessor.getEremitaManager().getById(MonitoraggioSpecie.class,m.getMonitoraggioSpecie().getId());
		//if (ms==null) return null;
		//if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();

		aggiornaTracciamento(m);
		m = (Segnalazione) Accessor.getEremitaManager().updateAndCommit(m);
		return m;
	}

	@GraphQLMutation(name="deleteSegnalazione")
	public Boolean deleteSegnalazione(@GraphQLArgument(name="id") Long id) {
		
		
		return Accessor.getEremitaManager().deleteAndCommit(Segnalazione.class,id);
	}
	
	
	/*
	 * SEGNALAZIONE ALTRE SPECIE
	 */
	@GraphQLMutation(name="updateSegnalazioneAltreSpecie")
	public SegnalazioneAltreSpecie updateSegnalazioneAltreSpecie(@GraphQLArgument(name="segnalazioneAltreSpecie") SegnalazioneAltreSpecie m) throws EremitaException {
		
		if (m==null) return null;
		if (m==null) return null;
		MonitoraggioSpecie ms = Accessor.getEremitaManager().getById(MonitoraggioSpecie.class,m.getMonitoraggioSpecie().getId());
		if (ms==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), ms))  throw new EremitaSecurityException();
		if (m.getSpecie()!=null && m.getSpecie().getId()==null) m.setSpecie(null);
		aggiornaTracciamento(m);
		m = (SegnalazioneAltreSpecie) Accessor.getEremitaManager().updateAndCommit(m);
		return m;
	}

	@GraphQLMutation(name="deleteSegnalazioneAltreSpecie")
	public Boolean deleteSegnalazioneAltreSpecie(@GraphQLArgument(name="id") Long id) throws EremitaException {
		
		return Accessor.getEremitaManager().deleteAndCommit(SegnalazioneAltreSpecie.class,id);
	}

	/*
	 * UTENTE
	 */
	@GraphQLMutation(name="updateUtente")
	public Utente updateUtente(@GraphQLArgument(name="monitoraggioSpecie") Utente m) throws EremitaException {
		
		if (m==null) return null;
		if (!ObjectAuthorizerFactory.isAuthorized(Accessor.getUtenteAttuale(sessionProvider), m))  throw new EremitaSecurityException();

		m = (Utente) Accessor.getEremitaManager().updateAndCommit(m);
		return m;
	}


	
	
	private void aggiornaTracciamento(Trackable<Utente,? extends Object> t) throws EremitaException {
		
		Utente u = Accessor.getUtenteAttuale(sessionProvider.getRequest());
		
		Date d = new Date();
		
		if (t.getId()==null || t.getDataCreazione()==null) {
			//creazione
			t.setUtenteCreazione(u);
			t.setDataCreazione(d);
		} else {
			//modifica
			t.setUtenteModifica(u);
			t.setDataModifica(d);
		}
		
	}
	
	private <X extends Identifiable<Long>>ValoreMetadato updateMetadatoOggetto(X m, String metadato, String valore) {
		Class c = EremitaManager.getEntityClass(m);
		if (c==null) return null;
		
		for (Annotation a : c.getAnnotations()) {
			if (a instanceof Metadata) {
				String entity = ((Metadata) a).nomeEntita();
				if (entity==null) return null;
				
				String s = "select * from main_valore_metadato where tipo_entita='"+entity+"' and id_entita="+m.getId()+" and metadato=?";
				ArrayList al = new ArrayList<>();
				al.add(metadato);
				ValoreMetadato vm = Accessor.getEremitaManager().getSqlSingleResult(ValoreMetadato.class, s, al);
				if (vm!=null) {
					vm.setValore(valore);
					vm = Accessor.getEremitaManager().forceUpdateAndCommit(vm);
					return vm;
				} else {
					vm = new ValoreMetadato();
					vm.setTipoEntita(entity);
					vm.setIdEntita(m.getId());
					vm.setValore(valore);
					vm.setMetadato(new Metadato());
					vm.getMetadato().setId(metadato);
					vm = Accessor.getEremitaManager().forceUpdateAndCommit(vm);
					return vm;
					
				}
			}
		}
		
		return null;
	}
	
	
	@GraphQLMutation(name="importa")
	public void importa() throws EremitaException {
		
		try {
		DBImporter.importaCoenagrionNew(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A2_Coe.CSV"));
		DBImporter.importaGraphoderusNew(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A2_Gra.CSV"));
		DBImporter.importaOsmoderma(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A2_Osm.CSV"));
		DBImporter.importaRosalia(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A2_Ros.CSV"));
			DBImporter.importaMonitoraggiHabitat(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A3_Osm.CSV"), 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
			DBImporter.importaMonitoraggiHabitat(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A3_Ros.CSV"), 1834, DBImporter.TRACCIATO_MH_ROSALIA);
			DBImporter.importaMonitoraggiHabitat(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A4_Coe.CSV"), 3938, DBImporter.TRACCIATO_MH_COENAGRION);
			DBImporter.importaMonitoraggiHabitat(DBImporter.importaCSV("C:\\Users\\favini_g\\Downloads\\A4_Gra.CSV"), 1971, DBImporter.TRACCIATO_MH_GRAPHODERUS);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
		/*Accessor.getEremitaManager().updateSql("delete from eremita_segnalazione",null);
		Accessor.getEremitaManager().updateSql("delete from eremita_segnal_altre_specie",null);
		Accessor.getEremitaManager().updateSql("delete from eremita_monit_specie_doc",null);
		Accessor.getEremitaManager().updateSql("delete from eremita_monitoraggio_specie",null);
		DBImporter.importaCoenagrion(DBImporter.COENAGRION);
		DBImporter.importaGraphoderus(DBImporter.GRAPHODERUS());
		DBImporter.importaGraphoderus(Graphoderus1.GRAPHODERUS);
		DBImporter.importaOsmoderma(Osmoderma1.OSMODERMA);
		DBImporter.importaOsmoderma(Osmoderma2.OSMODERMA);
		DBImporter.importaOsmoderma(Osmoderma3.OSMODERMA);
		DBImporter.importaOsmoderma(Osmoderma4.OSMODERMA);
		DBImporter.importaOsmoderma(Osmoderma5.OSMODERMA);
		DBImporter.importaOsmoderma(Osmoderma6.OSMODERMA);
		DBImporter.importaOsmoderma(Osmoderma7.OSMODERMA);
		
		DBImporter.importaRosalia(Rosalia1.ROSALIA);
		DBImporter.importaRosalia(Rosalia2.ROSALIA);
		DBImporter.importaRosalia(Rosalia3.ROSALIA);
		DBImporter.importaRosalia(Rosalia4.ROSALIA);
		DBImporter.importaRosalia(Rosalia5.ROSALIA);
		DBImporter.importaRosalia(Rosalia6.ROSALIA);
		DBImporter.importaRosalia(Rosalia7.ROSALIA);
		DBImporter.importaRosalia(Rosalia8.ROSALIA);
		DBImporter.importaRosalia(Rosalia9.ROSALIA);
		DBImporter.importaRosalia(Rosalia10.ROSALIA);*/
		
		/*Accessor.getEremitaManager().updateSql("delete from eremita_metadato_habitat",null);
		//Accessor.getEremitaManager().updateSql("delete from main_metadato",null);
		Accessor.getEremitaManager().updateSql("delete from eremita_monitoraggio_habitat",null);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH2.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH3.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH4.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH5.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH6.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH7.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH8.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(OsmodermaMH9.OSMODERMA, 1874, DBImporter.TRACCIATO_MH_OSMODERMA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH2.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH3.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH4.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH5.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH6.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH7.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		DBImporter.importaMonitoraggiHabitat(RosaliaMH8.ROSALIA, 1834, DBImporter.TRACCIATO_MH_ROSALIA);
		
		
		DBImporter.importaMonitoraggiHabitat(CoenagrionMH.COENAGRION, 3938, DBImporter.TRACCIATO_MH_COENAGRION);
		DBImporter.importaMonitoraggiHabitat(GraphoderusMH.GRAPHODERUS, 1971, DBImporter.TRACCIATO_MH_GRAPHODERUS);*/
	}
	
}
